# Début programme de démonstration de la sortie PWM programmable D3

# PWM est l'acronyme anglais de : Pulse Width Modulation
# Sortie PWM peut etre traduit en "Signal de périodique a largeur d'impulsion variable"
# -> Les paramètres de temps du singal sont programmable.
# -> L'amplitude du signal est elle fixe a 0 ou 5v (non programmable)

# Une sortie PWM a l'avantage de fonctionner de facon autonome.
# Une sortie PWM dépend d'un Timer/Compteur en mode de comptage continuel.
# Une sortie PWM ne ne dépend pas d'un programme pour maintenir la production d'un singal périodique. 
#
# Les parametres a maitriser pour configurer une sortie PWM sont :
# - frequence/interval de temps de comptage du Timer.
# - largeur de la période du signal (fréquence de répétition du signal)
# - largeur de la portion haute(5V) du signal (rapport cyclique)
#
# Ces paramètre détermine les registres de configuration d'un Timer/Compteur (interne au microcontroleur).
# Un Timer/Compteur n'a pas de notion de temps, l'exercice de configuration consiste a recouper les...
# ...différents paramètres de configuration pour obtenir les caractéristiques d'un signal périodique souhaité.
# 
# PWM est notament la seule méthode offerte par pyfirmata2Ext pour générer un signal périodique rapide.

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

###########################################################
# Méthode de configuration des paramètres d'une sortie PWM
###########################################################
#
# 1. Définir l'unité de temps de comptage du Timer associé a la sortie PWM
# --> Sélectionner le prescaler du signal d'horloge a l'entrée du Timer
# --> le terme prescaler peut etre compris comme diviseur
# --> un prescaler définit a 1 ne divise pas le signal d'horloge
# --> un prescaler définit a 8 comptera 8 impulsions d'horloge d'entré...
# ....pour incrementer de 1 son registre de comptage ; Il divise donc par 8.
# --> La fréquence de comptage de base du Timer est fixé a 8 MHz
# --> La valeur assigné au prescaler peut etre : 1/8/32/64/128/256/1024
#
# 2. Définir la largeur de la période du signal PWM souhaité
# --> Connaissant l'unité de temps de comptage du Timer nous déterminons...
# ....de combien de fois il est nécessaire de répéter cette interval de temps...
# ....pour obtenir la largeur de la période du signal PWM souhaité.
# ....Le Timer associer a la sortie PWM devra etre capable de compter cette valeur.
# ....Cette valeur se nomme période.
# --> Un Timer a une limite de valeur de comptage maximum.
# --> La largeur (en bit) du regsitre de comptage definit sa valeur de comptage maximum.
# --> Le Timer associe a la sortie PWM D3 est de résolution 8-bit.
# --> 8-bits de résolution signifie que le Timer est capable de compter de 0 a 255.
# ----> 1111 1111 en binaire correspond a = 255 en base décimal.
#
# 3. Définir la proportion d'impulsion haute et basse du signal PWM souhaité
# --> Connaissant la largeur de la periode du signal on determine quelle fraction...
# ....de cette largeur est haute (5V) ; Le restant, soit la partie basse (0V)...
# ....correspondant a : largeur période - largeur d'impulsion haute = largeur d'impulsion basse.
# --> La proportion d'impulsion haute et basse ce nome rapport cyclique ou  duty cycle.
# --> La valeur de registe de rapport cyclique doit etre comprise entre 0 et valeur de période
#
###########################################################


# Correspondance Prescaler/Interval temps de comptage/Fréquence signal PWM Min/Max :

# PRESCALER # --Interval-- #FreqPeriode_MIN#FreqPeriode_MAX#
# ----------# -------------#-(periode=255)-#-(periode=002)-#
#---1024----# ---128 us----#-----30.637Hz--#--3906.250Hz---#
#----256----# ----32 us----#----122.549Hz--#-----15625Hz---#
#----128----# ----16 us----#----245.098Hz--#-----31250Hz---#
#-----64----# -----8 us----#----490.196Hz--#-----62500Hz---#
#-----32----# -----4 us----#----980.391Hz--#----125000Hz---#
#------8----# -----1 us----#---3921.568Hz--#----500000Hz---#
#------1----# ---125 ns----#--31372.549Hz--#---4000000Hz---#
#----------------------------------------------------------#
# --> La fréquence de comptage de base du Timer est fixé a 8 MHz
# Fréquence PWM = ( ( FréquenceHorlogeEntréeTimer / Prescaler ) / valeur a compter pour 1 période )
# 30.637 Hz = ( ( 8 000 000 / 1024 ) / 255 )

# Exemple 1, obtenir un signal PWM a 44 Hz et rapport cyclique 0.5
# Durée impulsion comptage Timer : ( 1 / 8 000 000 ) * 1024 = 128us
# Durée de la période d'un signal a 44 Hz = 22.72 ms
# Déterminer la valeur de période ideal : 0.02272 / 0.000128 =  177.55 ->178<-
# Determiner la portion de signal haut pour un rapport cyclique a 0.5 : 177 / 2 = 89
plugUno.setPWMConfigD3( prescaler=1024, period=178, dutyCycle=89 )
# -> Selon ces parametre, la frequence obtenue est de 43.89 Hz et un rapport cyclique de 0.5
print(
    "\n"
    "PWM D3 : 43.8 Hz et rapport cyclique 0.5"
    "\n"
)

sleep(5) # Patienter 10 secondes

# Exemple 2, obtenir un signal PWM a 12345.67 Hz et un rapport cyclique de 0.8
# Durée impulsion comptage Timer : ( 1 / 8 000 000 ) * 8 = 1us
# Durée de la période d'un signal a 12345.67 Hz = 81 us
# Déterminer la valeur de période ideal : 0.000081 / 0.000001 =  81
# Determiner la portion de signal haut pour un rapport cyclique a 0.5 : 81 / 2 = 40.5 ->41<-
plugUno.setPWMConfigD3( prescaler=8, period=81, dutyCycle=41 )
# -> Selon ces parametre, la frequence obtenue est de 12 345.67 KHz et un rapport cyclique de 0.506
print(
    "\n"
    "PWM D3 : 12 345.6 KHz  et rapport cyclique 0.5"
    "\n"
)

sleep(5) # Patienter 10 secondes

# Fermer la connection a Plug'Uno
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme de démonstration de la sortie PWM programmable D3

    

